 /**************************************************************************************
 
   Copyright (c) Hilscher GmbH. All Rights Reserved.
 
 **************************************************************************************
 
   Filename:
    $Id: ConnectorAPI.cpp 2363 2010-11-19 12:13:46Z MichaelT $
   Last Modification:
    $Author: MichaelT $
    $Date: 2010-11-19 13:13:46 +0100 (Fr, 19 Nov 2010) $
    $Revision: 2363 $
   
   Targets:
     Win32/ANSI   : yes
     Win32/Unicode: no
     WinCE        : no
 
   Description:
    Implementation of the netX Connector API
       
   Changes:
 
     Version   Date        Author   Description
     ----------------------------------------------------------------------------------
      1        28.07.09    SS       initial version
 
**************************************************************************************/

/*****************************************************************************/
/*! \file ConnectorAPI/ConnectorAPI.cpp                                      */
/*   netX Connector API implementation                                       */
/*****************************************************************************/

#include "stdafx.h"
#include "ConnectorAPI.h"
#include "netXConnectorErrors.h"


/*****************************************************************************/
/*! \addtogroup netX_CONNECTOR_API netX Connector API implementation         */
/*! \{                                                                       */
/*****************************************************************************/

/* 
 *   UUID of the Connector, TODO: add your own UUID 
 *   const UUID g_tConnectorUUID = { 0x1719D5A0, 0xDD3B, 0x48e2, {0xBB, 0xF6, 0xDD, 0xDA, 0xAE, 0xD7, 0xE8, 0xB7} };
 */
 
#define MY_CONNECTOR_IDENTIFIER "ABC" /*!< Unique identifier for the interfaces e.g. COM, TCP ... */
 
/***************************************************************************
* 
*   
*   Connector API Functions
*
*
*
*
*
******************************************************************************/

/*****************************************************************************/
/*! Get identifier and UUID of the connector
*   \param  szIdentifier Returns identifier of the connector
*   \param  pvUUID       Returns UUID of the connector
*   \return NXCON_NO_ERROR on success                                        */
/*****************************************************************************/
long APIENTRY netXConGetIdentifier( char* szIdentifier, void* pvUUID)
{
  if(!szIdentifier)
    return NXCON_DRV_INVALID_POINTER;

  if(!pvUUID)
    return NXCON_DRV_INVALID_POINTER;
  
  /* Copy identifier of the connector */
  strcpy( szIdentifier, MY_CONNECTOR_IDENTIFIER);

  /* Copy UUID of the connector */
  UUID* ptUUID = (UUID*)pvUUID;
  *ptUUID      = g_tConnectorUUID;
  
  return NXCON_NO_ERROR;
}

/*****************************************************************************/
/*! Open the connector
*   \param  pfnDevNotifyCallback  Function pointer for the callback
*   \param  pvUser                User pointer
*   \return NXCON_NO_ERROR on success                                        */
/*****************************************************************************/
long APIENTRY netXConOpen( PFN_NETXCON_DEVICE_NOTIFY_CALLBACK pfnDevNotifyCallback, void* pvUser)
{
  return NXCON_DRV_FUNC_NOT_IMPL;
}

/*****************************************************************************/
/*! Close a open connector 
*   \return NXCON_NO_ERROR on success                                        */
/*****************************************************************************/
long APIENTRY netXConClose(void)
{ 
  return NXCON_DRV_FUNC_NOT_IMPL;
}

/*****************************************************************************/
/*! Create device interface for the connector
*   \param  szDeviceName    Name of the interface (e.g. TCP0)
*   \return PCONNECTOR_INTERFACE on success                                  */
/*****************************************************************************/
PCONNECTOR_INTERFACE APIENTRY netXConCreateInterface( const char* szDeviceName)
{ 
  return NXCON_DRV_FUNC_NOT_IMPL;
}

/*****************************************************************************/
/*! Start the connector interface
*   \param  pvInterface     Pointer of the interface 
*   \param  pfnReceiveData  Function pointer of the receive callback
*   \param  pvUser          User pointer
*   \return NXCON_NO_ERROR on success                                        */
/*****************************************************************************/
long APIENTRY netXConStartInterface( PCONNECTOR_INTERFACE pvInterface, PFN_NETXCON_DEVICE_RECEIVE_CALLBACK pfnReceiveData, void* pvUser)
{ 
  if(!pvInterface)
    return NXCON_DRV_INVALID_POINTER;

  return NXCON_DRV_FUNC_NOT_IMPL;
}

/*****************************************************************************/
/*! Stop the connector interface 
*   \param  pvInterface   Pointer of the interface 
*   \return NXCON_NO_ERROR on success                                        */
/*****************************************************************************/
long APIENTRY netXConStopInterface(PCONNECTOR_INTERFACE pvInterface)
{ 
  if(!pvInterface)
    return NXCON_DRV_INVALID_POINTER;

  return NXCON_DRV_FUNC_NOT_IMPL;
}

/*****************************************************************************/
/*! Send data via the connector interface 
*   \param  pvInterface    Pointer of the interface 
*   \param  pabData        Data pointer
*   \param  ulDataLen      Length of the send data 
*   \return NXCON_NO_ERROR on success                                        */
/*****************************************************************************/
long APIENTRY netXConSendInterface( PCONNECTOR_INTERFACE pvInterface, unsigned char* pabData, unsigned long ulDataLen)
{ 
  if( !pvInterface  ||
      !pabData        )
    return NXCON_DRV_INVALID_POINTER;

  return NXCON_DRV_FUNC_NOT_IMPL;
}

/*****************************************************************************/
/*! Get the configuration
*   \param  pvConfig     Pointer to result of the request
*   \param  eCmd         eCMD_CONFIG_GETLEN/eCMD_CONFIG_GETSTRING/
*                        eCMD_DIALOG_GETLEN/eCMD_DIALOG_GETSTRING
*   \return NXCON_NO_ERROR on success                                        */
/*****************************************************************************/
long APIENTRY netXConGetConfig( NETX_CONNECTOR_CONFIG_CMD_E eCmd, void* pvConfig)
{ 
  long lRet = NXCON_NO_ERROR;

  if( !pvConfig)
    return NXCON_DRV_INVALID_POINTER;

  switch (eCmd)
  {
    case eCMD_CONFIG_GETLEN:
      {
        unsigned long* pulLength = (unsigned long*)pvConfig;
      }
      break;

    case eCMD_CONFIG_GETSTRING:
      {
        char* pszString = (char*)pvConfig;
      }
      break;
    
    case eCMD_DIALOG_GETLEN:
      {
        unsigned long* pulLength = (unsigned long*)pvConfig;
      }
      break;

    case eCMD_DIALOG_GETSTRING:
      {
        char* pszString = (char*)pvConfig;
      }
      break;

    default:
      lRet = NXCON_DRV_INVALID_PARAMETER;
      break;
  }

  return lRet;
}

/*****************************************************************************/
/*! Set the connector configuration
*   \param  eCmd         eCMD_CONFIG_SETSTRING/eCMD_DIALOG_SETSTRING
*   \param  szConfig     Configuration string
*   \return NXCON_NO_ERROR on success                                        */
/*****************************************************************************/
long APIENTRY netXConSetConfig( NETX_CONNECTOR_CONFIG_CMD_E eCmd, const char* szConfig)
{ 
  long lRet = NXCON_NO_ERROR;

  if( !szConfig)
    return NXCON_DRV_INVALID_POINTER;
  
  switch (eCmd)
  {
    case eCMD_CONFIG_SETSTRING:
      break;

    case eCMD_DIALOG_SETSTRING:
      break;

    default:
      lRet = NXCON_DRV_INVALID_PARAMETER;
      break;
  }

  return lRet;
}

/*****************************************************************************/
/*! Get connector information
*   \param  eCmd            eSTATE/eUUID/eTYPE/eESTABLISH_TIMEOUT
*   \param  ulSize          Size of information structure
*   \param  pvConnectorInfo Connector information structure
*   \return NXCON_NO_ERROR on success                                        */
/*****************************************************************************/
long APIENTRY netXConGetInformation( NETX_CONNECTOR_INFO_E eCmd, unsigned long ulSize, void* pvConnectorInfo)
{
  if (!pvConnectorInfo)
    return NXCON_DRV_INVALID_POINTER;

  long lRet = NXCON_NO_ERROR;

  switch(eCmd)
  {
    case eSTATE:   
      if(sizeof(NETX_CONNECTOR_INFO_STATE_T) >= ulSize)
      {
        NETX_CONNECTOR_INFO_STATE_T* ptConnectorState = (NETX_CONNECTOR_INFO_STATE_T*)pvConnectorInfo;
        /* Populate Connector Info structure */
      }else
      {
        lRet = NXCON_DRV_BUFFER_TOO_SHORT;
      }
    break;

    case eUUID:
      if(sizeof(UUID) >= ulSize)
      {
        UUID* ptUUID = (UUID*)pvConnectorInfo;
        *ptUUID      = g_tConnectorUUID;
      } else
      {
        lRet = NXCON_DRV_BUFFER_TOO_SHORT;
      }
    break;
    
    case eTYPE:  
      if(sizeof(NETX_CONNECTOR_TYPE_T) >= ulSize)
      {
        NETX_CONNECTOR_TYPE_T* ptConnectorType = (NETX_CONNECTOR_TYPE_T*)pvConnectorInfo;
        
        /* Clear Connector Type structure */
        ptConnectorType->uTYPE.ulType = 0;
        /* Populate Connector Type structure */
        ptConnectorType->uTYPE.tBfType.fNXDRV_TYPE_ETHERNET = TRUE;

      }else
      {
        lRet = NXCON_DRV_BUFFER_TOO_SHORT;
      }
    break;
    
    case eESTABLISH_TIMEOUT:  
      if(sizeof(unsigned long) >= ulSize)
      {
        unsigned long* pulInitTimeout = (unsigned long*)pvConnectorInfo;
        /* Populate Connector Info structure */
      }else
      {
        lRet = NXCON_DRV_BUFFER_TOO_SHORT;
      }
    break;

    default:
      lRet = NXCON_DRV_INVALID_PARAMETER;
      break;
  }
  
  return lRet;
}


/*****************************************************************************/
/*! Get interface information
*   \param  pvInterface     Reference to interface object
*   \param  eCmd            eINTERFACE_STATE/eINTERFACE_NAME/eHUMAN_READABLE_NAME/
*                           eSEND_TIMEOUT/eRESET_TIMEOUT/eKEEPALIVE_TIMEOUT                
*   \param  ulSize          Size of information structure
*   \param  pvInterfaceInfo Interface information structure
*   \return NXCON_NO_ERROR on success                                        */
/*****************************************************************************/
long APIENTRY netXConGetInformationInterface( PCONNECTOR_INTERFACE pvInterface, NETX_INTERFACE_INFO_E eCmd, unsigned long ulSize, void* pvInterfaceInfo)
{
  if (!pvInterfaceInfo)
    return NXCON_DRV_INVALID_POINTER;

  if(!pvInterface)
    return NXCON_DRV_INVALID_POINTER;

  long lRet = NXCON_NO_ERROR;

  switch(eCmd)
  {
    case eINTERFACE_STATE:   
      if(sizeof(unsigned long) >= ulSize)
      { 
        unsigned long* pulInterfaceState = (unsigned long*)pvInterfaceInfo;

      }else
      {
        lRet = NXCON_DRV_BUFFER_TOO_SHORT;
      }
    break;

    case eINTERFACE_NAME:
      /* Populate interface name string buffer */
      break;
    
    case eHUMAN_READABLE_NAME:
      /* Populate human readable name string buffer */
      break;

    case eSEND_TIMEOUT:  
      if(sizeof(unsigned long) >= ulSize)
      {
        unsigned long* pulInterfaceTimeout = (unsigned long*)pvInterfaceInfo;
      }else
      {
        lRet = NXCON_DRV_BUFFER_TOO_SHORT;
      }
    break;

    case eRESET_TIMEOUT:  
      if(sizeof(unsigned long) >= ulSize)
      {
        unsigned long* pulInterfaceTimeout = (unsigned long*)pvInterfaceInfo;
      }else
      {
        lRet = NXCON_DRV_BUFFER_TOO_SHORT;
      }
    break;

    case eKEEPALIVE_TIMEOUT:  
      if(sizeof(unsigned long) >= ulSize)
      {
        unsigned long* pulInterfaceTimeout = (unsigned long*)pvInterfaceInfo;
      }else
      {
        lRet = NXCON_DRV_BUFFER_TOO_SHORT;
      }
    break;

    default:
      lRet = NXCON_DRV_INVALID_PARAMETER;
      break;

  }
  
  return lRet;
}

/*****************************************************************************/
/*! Display configuration dialog
*   \param  hParentWnd Parent Window
*   \param  szConfig   Configuration string to configure dialog
*   \return Handle to dialog window                                          */
/*****************************************************************************/
HWND APIENTRY netXConCreateDialog (HWND hParentWnd, const char* szConfig)
{
  if( !hParentWnd)
    return NULL;

  return NULL;
}

/*****************************************************************************/
/*! Remove configuration dialog
*                                                                            */
/*****************************************************************************/
void APIENTRY netXConEndDialog ()
{
}

/*****************************************************************************/
/*! \}                                                                       */
/*****************************************************************************/

